package com.fireflye.proyectos.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

import com.fireflye.proyectos.dto.Proyectos;

import lombok.extern.slf4j.Slf4j;

@Service
@Scope("singleton")
@Slf4j
public class ProyectosServiceImpl implements ProyectosService {

	private List<Proyectos> proyectosList = new ArrayList<>();
	
	@Autowired
	private UsuariosService usuariosService;

	@Override
	@Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	public void addProyecto(Proyectos proyectos) throws ProyectosException{
		validateUsuario(proyectos.getIdUsuario());
//		usuariosService.validarUsuario(proyectos.getIdUsuario());
		proyectosList.add(proyectos);

	}

	@Override
	@Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	public void deleteProyecto(Integer idProyecto) {

		Proyectos userToDelete = null;

		for (Proyectos usuarios : proyectosList) {
			if (usuarios.getIdProyecto().equals(idProyecto)) {
				userToDelete = usuarios;
			}
		}
		if (userToDelete != null) {
			proyectosList.remove(userToDelete);
		}

	}

	@Override
	@Transactional(readOnly = true)
	public Proyectos getProyecto(Integer idProyecto) {
		for (Proyectos usuarios : proyectosList) {
			if (usuarios.getIdProyecto().equals(idProyecto)) {
				return usuarios;
			}
		}

		return null;
	}

	@Override
	@Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	public void updateProyecto(Proyectos proyectos) throws ProyectosException {
		deleteProyecto(proyectos.getIdProyecto());
		addProyecto(proyectos);

	}

	@Override
	@Transactional(readOnly = true)
	public List<Proyectos> listProyectos() {
		return proyectosList;
	}

	private void validateUsuario(Integer idUsuario) throws ProyectosException {
		RestTemplate restTemplate = new RestTemplate();
		String url = "http://super-usuarios/servicios/usuarios/validate/" + idUsuario;
		ResponseEntity<Void> response = restTemplate.getForEntity(url, Void.class);

		if (!response.getStatusCode().equals(HttpStatus.OK)) {
			throw new ProyectosException();
		}

	}

}
