package com.fireflye.usuarios.dto;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Usuarios {
	
	@NotNull(message = "El nombre no puede ser vacio")
	@NotEmpty(message = "El nombre no puede ser vacio")
	private String nombre;
	@NotNull(message = "El apellido no puede ser vacio")
	@NotEmpty(message = "El apellido no puede ser vacio")
	private String apellido;
	private String telefono;
	@Email(message = "Email no válido")
	private String email;
	@Positive(message = "El id tiene que ser un número positivo")
	private Integer idUsuario;
	
}
