package com.fireflye.proyectos.dto;

import java.util.Date;

import javax.validation.constraints.Future;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.PastOrPresent;
import javax.validation.constraints.Positive;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Proyectos {

	@Positive(message = "El id tiene que ser un número positivo")
	private Integer idProyecto;
	@NotNull(message = "El nombre no puede ser vacio")
	@NotEmpty(message = "El nombre no puede ser vacio")
	private String nombre;
	@Positive(message = "El id tiene que ser un número positivo")
	private Integer idUsuario;
	@PastOrPresent(message = "La fecha de inicio tiene que ser igual o menor a la del sistema")
	private Date fechaInicio;
	@Future(message = "La fecha de fin tiene que ser fecha mayor a la del sistema")
	private Date fechaFin;
}
