package com.fireflye.proyectos.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.context.annotation.Scope;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

import com.fireflye.proyectos.dto.Usuarios;

import lombok.extern.slf4j.Slf4j;

@Service
@Scope("singleton")
@Slf4j
public class UsuariosServiceImpl implements UsuariosService{
	
	private List<Usuarios> usuariosList = new ArrayList<>();

	@Override
	public void validarUsuario(Integer idUsuario) throws ProyectosException {
		for (Usuarios usuarios : usuariosList) {
			if (usuarios.getIdUsuario().equals(idUsuario)) {
				return;
			}
		}

		throw new ProyectosException();
		
	}
	
	@KafkaListener(topics = "alumno6", groupId = "test-consumer-group")
	public void listenerUsuarios(Usuarios usuario) {
		usuariosList.add(usuario);
	}
	

}
