package com.fireflye.usuarios.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.fireflye.usuarios.dto.Usuarios;

import lombok.extern.slf4j.Slf4j;

@Service
@Scope("singleton")
@Slf4j
public class UsuariosServiceImpl implements UsuariosService {
	
	@Autowired
	private KafkaTemplate<String, Usuarios> kafkaTemplate;

	private List<Usuarios> usuariosList = new ArrayList<>();

	@Override
	@Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	public void addUsuario(Usuarios usuarios) {
		usuariosList.add(usuarios);
		
		kafkaTemplate.send("alumno6", usuarios.getNombre(), usuarios);
	}

	@Override
	@Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	public void deleteUsuario(Integer idUsuario) {

		Usuarios userToDelete = null;

		for (Usuarios usuarios : usuariosList) {
			if (usuarios.getIdUsuario().equals(idUsuario)) {
				userToDelete = usuarios;
			}
		}
		if (userToDelete != null) {
			usuariosList.remove(userToDelete);
		}

	}

	@Override
	@Transactional(readOnly = true)
	public Usuarios getUsuario(Integer idUsuario) {
		for (Usuarios usuarios : usuariosList) {
			if (usuarios.getIdUsuario().equals(idUsuario)) {
				return usuarios;
			}
		}

		return null;
	}

	@Override
	@Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	public void updateUsuario(Usuarios usuario) {
		deleteUsuario(usuario.getIdUsuario());
		addUsuario(usuario);

	}

	@Override
	@Transactional(readOnly = true)
	public List<Usuarios> listUsuarios() {
		return usuariosList;
	}

	@Override
	@Transactional(readOnly = true)
	public void validateUsuario(Integer idUsuario) throws UsuariosException {
		if (getUsuario(idUsuario) == null) {
			throw new UsuariosException();
		}

	}

}
